package tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.jfree.data.category.DefaultCategoryDataset;

import edu.vub.at.eval.Evaluator;
import edu.vub.at.exceptions.InterpreterException;
import edu.vub.at.objects.ATObject;
import edu.vub.at.objects.ATTable;
import edu.vub.at.objects.mirrors.NativeClosure;
import edu.vub.at.objects.natives.NATBoolean;
import edu.vub.at.objects.natives.NATNumber;
import edu.vub.at.objects.natives.NATText;

import benchmarks.TestClasses;
import benchmarks.TestMethods;
import junit.framework.TestCase;

public class Tests extends TestCase{
	
	protected TestMethods currentLib;
	
	public void testCopyNATText() throws ClassNotFoundException, IOException{
		assertEquals(TestClasses.boeTXT, currentLib.copy(TestClasses.boeTXT));
	}
	
	public void testCopyAG() throws ClassNotFoundException, IOException{
		assertEquals(TestClasses.ass.toString(), currentLib.copy(TestClasses.ass).toString());
	}
	
	public void testCopyParseTree() throws ClassNotFoundException, IOException{
		assertEquals(TestClasses.ag.toString(), currentLib.copy(TestClasses.ag).toString());
	}
	
	public void testCyclic() throws ClassNotFoundException, IOException{
		Cyclic a = new Cyclic();
		Cyclic b = new Cyclic();
		a.object = b;
		b.object = a;
		assertEquals(a.toString(), currentLib.copy(a).toString());
	}
	
	public void testCopyIsolet() throws ClassNotFoundException, IOException, InterpreterException{
		String first = TestClasses.isolate.meta_print().meta_print().javaValue;
		String seccond = ((ATObject) currentLib.copy(TestClasses.isolate)).meta_print().meta_print().javaValue;
		System.out.println(first + "//" + seccond);

		String a = first.substring(first.indexOf("{"));
		String b  = seccond.substring(seccond.indexOf("{"));
				
		System.out.println(a);
		System.out.println(b);
		
		assertEquals(a, b);
	}
}

